* NOTE, I EXCLUDE 80 AND 81 FROM THIS IMPUTATION (drop if period==0)
* I DO THIS BECAUSE WE DON'T USE IMPUTED RENTAL EQUIVALENT IN 80-81 BECAUSE WE DON'T
* OBSERVE WHETHER IN GOV'T/SUBSIDIZED HOUSING.  ALSO NOTE THAT STATE CODES CHANGE AFTER 1981, SO 
* I WOULD NEED TO EDIT THE CODE TO REFLECT THIS TO USE 80-81

set mem 700m
set mat 800

infile newid ref_year state totexp region age_ref bls_urbn fam_size fam_type marital1 ref_race sex_ref educ_ref fullrent mo_rent rooms publhous govtcost stove microw frig freezer disposal dishw win_ac cen_ac washer dryer bedroom bathrm hlfbath smsastat using C:\Users\jsulliv4\Documents\stata\statadat.dat

*statadat.dat is a large file so keep it on unix--~/jim/poverty/output

* RECODE FULLRENT SO THAT 80-81 IS NOT INCLUDED IN REGRESSIONS
replace fullrent=1 if ref_year<=1981

generate agesq= age_ref*age_ref 

generate period=0
replace period=1 if ref_year==1984
replace period=1 if ref_year==1985
replace period=1 if ref_year==1986
replace period=2 if ref_year==1987
replace period=2 if ref_year==1988
replace period=2 if ref_year==1989
replace period=3 if ref_year==1990
replace period=3 if ref_year==1991
replace period=3 if ref_year==1992
replace period=4 if ref_year==1993
replace period=4 if ref_year==1994
replace period=4 if ref_year==1995
replace period=5 if ref_year==1996
replace period=5 if ref_year==1997
replace period=5 if ref_year==1998
replace period=6 if ref_year==1999
replace period=6 if ref_year==2000
replace period=6 if ref_year==2001
replace period=6 if ref_year==2002
replace period=7 if ref_year==2003
replace period=7 if ref_year==2004
replace period=7 if ref_year==2005
replace period=7 if ref_year==2006
replace period=7 if ref_year==2007
replace period=7 if ref_year==2008
replace period=7 if ref_year==2009
replace period=7 if ref_year==2010
replace period=7 if ref_year==2011

drop if period==0
drop if bedroom >10 & bedroom ~=.
drop if bathrm >10 & bathrm ~=.

gen region2=region
replace region2=0 if region ==.

gen room_nm=0
replace room_nm=1 if rooms ~=.

gen bath_nm=0
replace bath_nm=1 if bathrm ~=.

gen bed_nm=0
replace bed_nm=1 if bedroom ~=.

gen stove_nm=0
replace stove_nm=1 if stove ~=.

gen microw_nm=0
replace microw_nm=1 if microw ~=.

gen frig_nm=0
replace frig_nm=1 if frig ~=.

gen freezer_nm=0
replace freezer_nm=1 if freezer ~=.

gen disposal_nm=0
replace disposal_nm=1 if disposal ~=.

gen dishw_nm=0
replace dishw_nm=1 if dishw ~=.

gen washer_nm=0
replace washer_nm=1 if washer ~=.

gen dryer_nm=0
replace dryer_nm=1 if dryer ~=.


gen room_nmX=0
replace room_nmX=rooms if rooms ~=.

gen bath_nmX=0
replace bath_nmX=bathrm if bathrm ~=.

gen bed_nmX=0
replace bed_nmX=bedroom if bedroom ~=.

gen stove_nmX=0
replace stove_nmX=stove if stove ~=.

gen microw_nmX=0
replace microw_nmX=microw if microw ~=.

gen frig_nmX=0
replace frig_nmX=frig if frig ~=.

gen freezer_nmX=0
replace freezer_nmX=freezer if freezer ~=.

gen disposal_nmX=0
replace disposal_nmX=disposal if disposal ~=.

gen dishw_nmX=0
replace dishw_nmX=dishw if dishw ~=.

gen washer_nmX=0
replace washer_nmX=washer if washer ~=.

gen dryer_nmX=0
replace dryer_nmX=dryer if dryer ~=.

gen bstate=0
replace bstate=1 if state==6
replace bstate=2 if state==12
replace bstate=3 if state==17
replace bstate=4 if state==36
replace bstate=5 if state==39
replace bstate=6 if state==42
replace bstate=7 if state==48
replace bstate=8 if state==99


gen urban= 2-bls_urbn
gen smsa= 2- smsastat

gen exp1=ln(max(totexp-mo_rent*3,1))
gen exp2=exp1*exp1

gen smsa_reg=smsa*region2

xi i.region2*urban i.region2*i.period i.bstate*smsa i.bstate*i.period i.bstate*i.ref_year i.bstate*urban i.ref_year*room_nm i.region2*win_ac i.region2*cen_ac i.period*microw_nmX i.period*disposal_nmX i.period*dishw_nmX i.period*dryer_nmX i.period*win_ac i.period*cen_ac i.bstate*i.smsa_reg i.state

gen ln_rent = .
replace  ln_rent=ln(mo_rent) if  mo_rent>50 & mo_rent ~=.
replace  ln_rent=ln(50) if  mo_rent<=50 & mo_rent ~=.

* RUN OLS REGRESSIONS AND QUANTILE REGRESSIONS

log using qreg_rent2, replace text


reg ln_rent urban smsa room_nm room_nmX bath_nm bath_nmX bed_nm bed_nmX stove_nmX microw_nmX frig_nmX freezer_nmX disposal_nmX dishw_nmX washer_nmX dryer_nmX win_ac cen_ac _Iref_year* _Istate* _Iregion2* _IregXurban* _IbstXper* _IregXwin_a* _IregXcen_a* _IperXmicro* _IperXdispo* _IperXdishw* _IperXdryer* _IperXwin_a* _IperXcen_a* if fullrent==1

predict yhat

qreg ln_rent urban smsa room_nm room_nmX bath_nm bath_nmX bed_nm bed_nmX stove_nmX microw_nmX frig_nmX freezer_nmX disposal_nmX dishw_nmX washer_nmX dryer_nmX win_ac cen_ac _Iref_year* _Istate* _Iregion2* _IregXurban* _IbstXper* _IregXwin_a* _IregXcen_a* _IperXmicro* _IperXdispo* _IperXdishw* _IperXdryer* _IperXwin_a* _IperXcen_a* if fullrent==1, q(.40) nolog

predict yhat40


reg ln_rent exp1 exp2 urban smsa room_nm room_nmX bath_nm bath_nmX bed_nm bed_nmX stove_nmX microw_nmX frig_nmX freezer_nmX disposal_nmX dishw_nmX washer_nmX dryer_nmX win_ac cen_ac _Iref_year* _Istate* _Iregion2* _IregXurban* _IbstXper* _IregXwin_a* _IregXcen_a* _IperXmicro* _IperXdispo* _IperXdishw* _IperXdryer* _IperXwin_a* _IperXcen_a* if fullrent==1

predict yhat_c

qreg ln_rent exp1 exp2 urban smsa room_nm room_nmX bath_nm bath_nmX bed_nm bed_nmX stove_nmX microw_nmX frig_nmX freezer_nmX disposal_nmX dishw_nmX washer_nmX dryer_nmX win_ac cen_ac _Iref_year* _Istate* _Iregion2* _IregXurban* _IbstXper* _IregXwin_a* _IregXcen_a* _IperXmicro* _IperXdispo* _IperXdishw* _IperXdryer* _IperXwin_a* _IperXcen_a* if fullrent==1, q(.40) nolog

predict yhat_c40


log off
log close

gen mo_rent40=exp(yhat40)
gen mo_rent_c40=exp(yhat_c40)
gen mo_rent2=exp(yhat)
gen mo_rent2_c=exp(yhat_c)

outfile newid mo_rent2 mo_rent2_c mo_rent40 mo_rent_c40 sex_ref using tosas_pred_rent10, replace

